#pragma once

#include "common.h"

namespace yxiva { namespace web { namespace backapi {

void reload_xconf(settings_ptr settings, const http_stream_ptr& stream)
{
    if (auto service_manager = find_service_manager(
            settings->api.webui.enabled ? settings->api.webui.service_manager :
                                          settings->api.auth_service_manager))
    {
        // Implies xconf update under the hood.
        service_manager->get_all_services(
            stream->ctx(), [stream](auto&& result, auto&& /*services*/) mutable {
                if (result)
                {
                    stream->result(ymod_webserver::codes::ok);
                }
                else
                {
                    stream->result(
                        ymod_webserver::codes::internal_server_error, result.error_reason);
                }
            });
    }
}

}}}
