#pragma once

#include "common.h"

namespace yxiva { namespace web { namespace backapi {

namespace {

string format_to_json(string key, string value)
{
    return "{\"" + key + "\": \"" + value + "\"}";
}

string format_missing_arguments(std::vector<string>& pars)
{
    std::ostringstream out;
    size_t count = pars.size();
    out << "missing arguments: ";
    for (size_t i = 0; i < count; i++)
    {
        out << pars[i];
        if (i < count - 1)
        {
            out << ", ";
        }
    }
    return out.str();
}
}

void sign(const http_stream_ptr& stream)
{
    auto req = stream->request();
    std::vector<string> empty_parameters;
    time_t timestamp;
    string uid = req->url.param_value("uid", "");
    if (uid.empty()) empty_parameters.push_back("uid");
    try
    {
        timestamp = req->url.param_value_cast<time_t>("ts", 0);
        if (timestamp == 0) empty_parameters.push_back("ts");
    }
    catch (const std::runtime_error& e)
    {
        return send_bad_request(stream, "bad parameter value: ts", e.what());
    }

    if (empty_parameters.size() > 0)
    {
        return send_bad_request(stream, format_missing_arguments(empty_parameters));
    }

    string format = req->url.param_value("format", "xml");
    if (format != "xml" && format != "json")
    {
        string error_message = "unknown format '" + format + "', supported formats: {xml, json}";
        return send_bad_request(stream, error_message);
    }

    if (std::time(nullptr) >= timestamp)
    {
        return send_bad_request(stream, "bad sign request", "invalid expired value");
    }
    string sign = yplatform::find<web::impl>("web")->make_sign(uid, timestamp);
    if (format == "xml")
    {
        stream->result(ymod_webserver::codes::ok, "<sign>" + sign + "</sign>");
    }
    else if (format == "json")
    {
        stream->result(ymod_webserver::codes::ok, format_to_json("sign", sign));
    }
}
}}}
