#include "base_web_subscriber.h"

#include <boost/bind.hpp>
#include <yplatform/net/types.h>
#include <yxiva/core/binary_protocol.h>
#include "web/find_deps.h"

#include "hacks.h"

namespace yxiva { namespace web {

base_web_subscriber::base_web_subscriber(
    task_context_ptr context,
    formatters::formatter_ptr formatter,
    std::time_t sign_expiration,
    const string& client_id)
    : context_(context)
    , formatter_(formatter)
    , sign_expiration_time_(sign_expiration)
    , created_time_(time_traits::clock::now())
    , client_id_(client_id)
{
}

base_web_subscriber::~base_web_subscriber()
{
    auto duration = time_traits::clock::now() - created_time_;

    std::stringstream ss;
    ss.precision(3);
    ss.setf(std::ios::fixed);
    ss << "subscriber destroyed: duration=" << float_seconds(duration).count() << " client_id=\""
       << client_id_ << "\"";

    YLOG_CTX_LOCAL(context_, debug) << ss.str();
}

void base_web_subscriber::notify_plain_text(const string& text)
{
    impl_notify_text(text);
}

void base_web_subscriber::notify(
    const user_info& info,
    const message& message,
    const string& context_id)
{
    string info_uid = static_cast<string>(info.uid);
    if (info_uid != message.uid)
    {
        YLOG_CTX_LOCAL(context_, error)
            << "conflict on notify: info.uid = " << info_uid << ", message.uid = " << message.uid;
        return;
    }

    if (message.type == message_content_type::binary)
    {
        binary_protocol::notification_header hdr = {
            message.uid, message.service, message.operation, message.transit_id
        };
        impl_notify_binary(binary_protocol::pack(hdr), message.raw_data);
        return;
    }

    std::stringstream msg_stream;
    (*formatter_)(info, message, context_id, msg_stream);

    impl_notify_text(msg_stream.str());
}

void base_web_subscriber::notify_connected(const connected_message& message)
{
    impl_notify_text(message.to_string());
}

}}
