#pragma once

#include <memory>
#include <ymod_webserver/request.h>
#include <ymod_webserver/response.h>
#include "web/formatters/kit.h"
#include <yxiva/core/types.h>
#include <processor/interface.h>
#include "web/settings.h"
#include "extract_requests.h"

namespace yxiva { namespace web {

class base_web_subscriber
    : public enable_shared_from_this<base_web_subscriber>
    , public yxiva::subscriber
{
public:
    base_web_subscriber(
        task_context_ptr context,
        formatters::formatter_ptr formatter,
        std::time_t sign_expiration,
        const string& client_id);

    ~base_web_subscriber();

    virtual const string& name() const = 0;

    std::time_t sign_exiration() const
    {
        return sign_expiration_time_;
    }

    bool is_expired() const override
    {
        return sign_expiration_time_ != 0 && time(NULL) > sign_expiration_time_;
    }

    void notify_plain_text(const string& text) override;

    void notify(const user_info& info, const message& message, const string& context_id) override;

    void notify_connected(const connected_message&) override;

    yplatform::task_context_ptr ctx() const override
    {
        return context_;
    }

protected:
    virtual void impl_notify_text(const string& message) = 0;
    virtual void impl_notify_binary(const string& /* header */, const string& /* message */)
    {
    }

    const string& client_id() const override
    {
        return client_id_;
    }

private:
    const task_context_ptr context_;
    const formatters::formatter_ptr formatter_;
    std::time_t sign_expiration_time_;
    time_traits::time_point created_time_;
    const string client_id_;
};

typedef shared_ptr<base_web_subscriber> web_subscriber_ptr;

}}
