#pragma once

#include "types.h"
#include <ymod_webserver/codes.h>
#include <ymod_webserver/response.h>
#include <yplatform/util/tuple_unpack.h>

namespace yxiva { namespace web {

template <typename Stream, typename Handler, typename... Args>
class bind_arguments_handler
{
    using handler_type = typename std::decay<Handler>::type;
    using args_tuple = std::tuple<typename std::remove_reference<Args>::type...>;

public:
    bind_arguments_handler(Handler&& handler, Args&&... args)
        : handler_(std::forward<Handler>(handler)), stored_args_(std::forward<Args>(args)...)
    {
    }

    template <typename... CallArgs>
    void operator()(const Stream& stream, CallArgs&&... call_args)
    {
        yplatform::util::call_with_tuple_args(
            handler_, stored_args_, stream, std::forward<CallArgs>(call_args)...);
    }

private:
    handler_type handler_;
    args_tuple stored_args_;
};

template <typename Handler, typename... Args>
inline bind_arguments_handler<ymod_webserver::http::stream_ptr, Handler, Args...> bind_arguments(
    Handler&& handler,
    Args&&... args)
{
    return bind_arguments_handler<ymod_webserver::http::stream_ptr, Handler, Args...>(
        std::forward<Handler>(handler), std::forward<Args>(args)...);
}

template <typename Handler, typename... Args>
inline bind_arguments_handler<websocket_rpc::stream_ptr, Handler, Args...> bind_arguments_websocket(
    Handler&& handler,
    Args&&... args)
{
    return bind_arguments_handler<websocket_rpc::stream_ptr, Handler, Args...>(
        std::forward<Handler>(handler), std::forward<Args>(args)...);
}

}}