#pragma once

#include <yxiva/core/subscription_id.h>
#include <yxiva/core/user_info.h>
#include <yxiva/core/types.h>

namespace yxiva {

struct channel_key
{
    service_name service;
    filter_t filter;
    string client;
    string session;

    bool fetch_history = false;

    local_id_t position = 0;
    unsigned history_count = 0;
    bool strict_position = false;

    string bb_connection_id;

    bool watch_subscribers = false;
    std::function<string(
        const string&,
        const string&,
        const string&,
        const string&,
        const string&,
        const string&,
        const string&)>
        make_sub_id = websocket_id_generator::make_default;

    channel_key() : service(""), filter(""), client(""), session("")
    {
    }

    channel_key(
        const service_name& service_,
        const filter_t& filter_ = filter_t(),
        const string& client_ = "",
        const string& session_ = "",
        const string& bb_connection_id_ = "")
        : service(service_)
        , filter(filter_)
        , client(client_)
        , session(session_)
        , bb_connection_id(bb_connection_id_)
    {
    }

    bool operator<(const channel_key& o) const
    {
        return std::tie(service, filter, client, session, fetch_history) <
            std::tie(o.service, o.filter, o.client, o.session, o.fetch_history);
    }

    bool operator==(const channel_key& o) const
    {
        return std::tie(service, filter, client, session, fetch_history) ==
            std::tie(o.service, o.filter, o.client, o.session, o.fetch_history);
    }

    bool matches(const string& /*operation*/, const string& user_client, const string& session_key)
        const
    {
        return (user_client.empty() || client.empty() || user_client == client) &&
            (session_key.empty() || session.empty() || session_key == session);
    }

    string to_string() const
    {
        std::stringstream s;
        s << "{" << service << ", filter: " << static_cast<string>(filter) << ", client: " << client
          << ", session: " << session << "}";
        return s.str();
    }
};

typedef std::vector<channel_key> channels_set;

struct ui_channels_set
{
    ui_channels_set(user_info ui, channels_set channels) : ui(ui), channels(channels)
    {
    }

    user_info ui;
    channels_set channels;
};

typedef std::vector<ui_channels_set> multi_channels_set;

}