#pragma once

#include <yxiva/core/types.h>
#include "processor/subscriber.h"
#include "extract_requests.h"
#include "future_close.h"
#include "base_web_subscriber.h"
#include "xivaws_subscriber_control.h"

namespace yxiva { namespace web {

inline void control_session(
    multi_channels_set const& channels,
    shared_ptr<base_web_subscriber> subscriber_shared,
    timer_ptr timer,
    time_duration const& timer_interval,
    future_close future_session_closed)
{
    yplatform::spawn(std::make_shared<xivaws_subscriber_control>(
        subscriber_shared, channels, timer, timer_interval, future_session_closed));
}

inline void control_session(
    user_info const& ui,
    channels_set const& channels,
    shared_ptr<base_web_subscriber> subscriber_shared,
    timer_ptr timer,
    time_duration const& timer_interval,
    future_close future_session_closed)
{
    multi_channels_set multichannels;
    multichannels.push_back(ui_channels_set({ ui, channels }));
    control_session(multichannels, subscriber_shared, timer, timer_interval, future_session_closed);
}

}}
