#include "schedule_unsubscribe_app.h"

#include <yxiva/core/platforms.h>
#include <yxiva/core/subscription_id.h>
#include <yplatform/find.h>

namespace yxiva { namespace web { namespace extapi {

void schedule_unsubscribe_app(
    http_stream_ptr stream,
    const string& service,
    const string& platform,
    const string& uuid)
{
    // TODO TLS only

    auto resolved_platform = ::yxiva::platform::resolve_alias(platform);
    if (resolved_platform.name.empty() || !resolved_platform.supported)
    {
        send_bad_request(stream, "this platform is not supported");
        return;
    }

    find_hubrpc()->async_get(
        stream->ctx(),
        {},
        "/add_broken_subscription",
        {
            { "id", make_mobile_subscription_id(uuid) },
            { "platform", resolved_platform.name },
            { "service", service },
        },
        handle_default_hub_codes(stream));
}

}}}
