#include "extract_requests.h"

#include "utils/service_list_parser.h"
#include <yxiva/core/split.h>
#include <yxiva/core/filter.h>

namespace yxiva { namespace web {

filter_set filter_from_tags(std::vector<std::vector<string>> tags)
{
    if (tags.empty()) return filter_set();
    filter::rules_t rules;
    filter::vars_t vars;
    for (const auto& tags_and : tags)
    {
        add_single_variable_rule(
            rules,
            vars,
            { filter::message_condition_type::has_tags, "", tags_and },
            filter::action::send_bright);
    }
    return filter_set(std::move(rules), std::move(vars), filter::action::skip);
}

channels_set compose_channels(
    const string& service,
    const string& client,
    const string& session_key,
    user_info const& /*ui*/)
{
    channels_set result;
    auto splitted =
        parse_service_list_with_tags(service, find_processor()->settings()->max_tags_per_service);

    for (auto const& item : splitted)
    {
        // @todo do not use to_string(), store filter_set in channel
        result.push_back({ service_name(item.service),
                           filter_from_tags(item.tags).to_string(),
                           client,
                           session_key });
    }

    return result;
}

multi_channels_set compose_channels(
    const string& service,
    const string& client,
    const string& session_key,
    const string& /*filter*/,
    auth_info const& auth)
{
    multi_channels_set result;
    for (size_t i = 0; i < auth.users.size(); ++i)
    {
        auto set = compose_channels(service, client, session_key, auth.users[i]);
        if (set.size())
        {
            result.push_back(ui_channels_set({ auth.users[i], set }));
        }
    }
    return result;
}

string extract_client_id(ymod_webserver::request_ptr& req)
{
    string client_id = req->url.param_value("client_id", processor::DEFAULT_CLIENT_ID);
    if (client_id.empty())
    {
        client_id = processor::DEFAULT_CLIENT_ID;
    }
    return client_id;
}

channels_set decode(ymod_webserver::request_ptr& req, user_info const& /*ui*/)
{
    channels_set result;
    filter_t filter = filter_t(req->url.param_value("filter", ""));
    string service_name_string = req->url.param_value("service", "");
    string client_id = extract_client_id(req);
    string session_key_string = req->url.param_value("session_key", "");
    service_name_string = hacks::fix_service_name_for_bar(service_name_string, client_id);

    auto processor = find_processor();
    auto splitted = parse_service_list_with_tags(
        service_name_string, processor->settings()->max_tags_per_service);

    for (auto it = splitted.begin(); it != splitted.end(); ++it)
    {
        // @todo do not use to_string(), store filter_set in channel
        result.push_back({ service_name(it->service),
                           filter_from_tags(it->tags).to_string(),
                           client_id,
                           session_key_string });
    }
    return result;
}

}}
