#pragma once

#include <vector>
#include <boost/range/adaptor/map.hpp>
#include <ymod_webserver/request.h>
#include <yxiva/core/types.h>
#include <processor/defaults.h>
#include "web/find_deps.h"
#include "channel_key.h"
#include "hacks.h"

namespace yxiva { namespace web {

channels_set compose_channels(
    const string& service,
    const string& client,
    const string& session_key,
    user_info const& ui);

multi_channels_set compose_channels(
    const string& service,
    const string& client,
    const string& session_key,
    const string& filter,
    const auth_info& auth);

string extract_client_id(ymod_webserver::request_ptr& req);
channels_set decode(ymod_webserver::request_ptr& req, const user_info& ui);

}}
