#pragma once

#include "hubrpc/impl.h"
#include "settings.h"
#include <rproxy/rproxy.h>
#include <processor/interface.h>
#include <service_manager/interface.h>
#include <mod_log/xivaws_log.h>
#include <ymod_httpclient/call.h>
#include <ymod_xconf/local_conf_storage.h>
#include <yplatform/find.h>

namespace yxiva { namespace web {

inline processor::processor_ptr find_processor()
{
    return yplatform::find<processor::processor, std::shared_ptr>("processor");
}

inline auto find_hubrpc()
{
    return yplatform::find<hubrpc, std::shared_ptr>("hubrpc");
}

inline ymod_xconf::local_conf_storage_ptr find_xconf()
{
    return yplatform::find<ymod_xconf::local_conf_storage>("xconf");
}

inline std::shared_ptr<service_manager> find_service_manager(const string& name)
{
    return yplatform::find_module<service_manager, std::shared_ptr>(name, true);
}

inline std::shared_ptr<rproxy> find_rproxy()
{
    return yplatform::find<rproxy, std::shared_ptr>("rproxy");
}

}}
