#pragma once

#include <yxiva/core/types.h>

#include <string>
#include <list>
#include <stdexcept>
#include <iostream>

namespace yxiva { namespace rfc2822 {

using std::list;
typedef string::size_type size_type;

string quote(const string&);
string quote(const list<string>&);
string paste(const list<string>&);
string join_address(const string&, const string&);
bool unquote_pair(const string&, size_type&, string&);
bool quoted_pair(const string&, size_type&, string&);
bool fws(const string&, size_type&, string&);
bool comment(const string&, size_type&, string&);
bool quoted_string(const string&, size_type&, string&);
bool atom(const string&, size_type&, string&);
bool dotatom(const string&, size_type&, string&);
bool xatom(const string&, size_type&, string&);
bool display_name(const string&, size_type&, list<string>&);
bool domain_literal(const string&, size_type&, string&);
bool addrspec(const string&, size_type&, string&, string&);
bool addrspec(const string&, size_type&, string&);
bool angleaddr(const string&, size_type&, string&, string&);
bool angleaddr(const string& src, size_type pos, string& dst);
bool address(const string&, size_type&, list<string>&, string&, string&);
bool address(const string&, size_type&, string&, string&);

struct invalid_address : public std::runtime_error
{
    invalid_address(const std::string& what) : std::runtime_error(what)
    {
    }
};

class address_iterator
{
    static const string empty;
    const string& src_;
    size_type pos_;
    string display_, local_, domain_, pretty_, address_;

public:
    address_iterator(void) : src_(address_iterator::empty), pos_(string::npos)
    {
    }

    address_iterator(const std::string& src) : src_(src), pos_(0)
    {
        operator++();
    }

    bool operator==(const address_iterator& x) const
    {
        return (&src_ == &x.src_ && pos_ == x.pos_) ||
            ((&src_ == &address_iterator::empty || &x.src_ == &address_iterator::empty) &&
             pos_ == string::npos && x.pos_ == string::npos);
    }

    bool operator!=(const address_iterator& x) const
    {
        return !operator==(x);
    }

    address_iterator& operator++(void);

    address_iterator operator++(int)
    {
        address_iterator tmp(*this);
        operator++();
        return tmp;
    }

    const string& display(void) const
    {
        return display_;
    }
    const string& pretty(void) const
    {
        return pretty_;
    }
    const string& local(void) const
    {
        return local_;
    }
    const string& domain(void) const
    {
        return domain_;
    };
    string address(void) const
    {
        return address_;
    }
};

}}
