#include "json.h"

#include <map>
#include <boost/lexical_cast.hpp>
#include <yxiva/core/map_utils.h>
#include <yxiva/core/quote_xml.h>
#include <yxiva/core/json.h>
#include <yxiva/core/services/names.h>

namespace yxiva { namespace formatters {
namespace {

const string VERSION = "1";

}

void json::operator()(
    const user_info&,
    const message& msg,
    const string& context_id,
    std::ostream& out) const
{
    json_value json_msg;

    json_msg["version"] = VERSION;
    if (is_topic_name(msg.uid))
    {
        auto range = decode_topic_name(msg.uid);
        json_msg["topic"] = string(range.begin(), range.end());
    }
    else
    {
        json_msg["uid"] = msg.uid;
    }
    json_msg["service"] = static_cast<string>(msg.service);
    json_msg["operation"] = msg.operation;
    json_msg["lcn"] = msg.lcn.empty() && msg.data.count("lcn") ? msg.data.at("lcn") : msg.lcn;
    json_msg["session_key"] = msg.session_key;
    json_msg["server_notify_id"] = context_id;
    json_msg["bright"] = msg.bright;

    if (msg.service == static_cast<std::string>(services::hardcoded_names::MAIL))
    {
        for (auto key_it = msg.data.begin(); key_it != msg.data.end(); key_it++)
            json_msg["message"][key_it->first] = key_it->second;
        json_msg["raw_data"] = msg.raw_data;
    }
    else
    {
        json_msg["message"] = msg.raw_data;
    }

    auto&& tags = json_msg["tags"];
    tags.set_array();
    for (const auto& tag : msg.tags)
    {
        tags.push_back(tag);
    }

    json_msg["position"] = msg.local_id;

    out << json_write(json_msg);
}

}}
