#pragma once

#include <map>
#include <yxiva/core/types.h>
#include "web/formatters/interface.h"

namespace yxiva { namespace formatters {

class kit
{
    typedef std::map<string, formatter_ptr> items_t;

public:
    void add(const string& name, formatter_ptr func)
    {
        items_.insert(std::make_pair(name, func));
    }

    bool has(const string& name) const
    {
        items_t::const_iterator it = items_.find(name);
        return (it != items_.end());
    }

    formatter_ptr get(const string& name) const
    {
        items_t::const_iterator it = items_.find(name);
        if (it == items_.end())
        {
            throw std::runtime_error("no such formatter \'" + name + "\'");
        }
        return it->second;
    }

private:
    items_t items_;
};

typedef shared_ptr<kit> kit_ptr;

}}
