#pragma once

#include "web/settings.h"
#include "web/arguments/service_and_filter.h"
#include <ymod_webserver/request.h>
#include <yxiva/core/types.h>

namespace yxiva { namespace web { namespace hacks {
inline service_name fix_service_name_for_bar(
    string const& original_name,
    string const& client_id_string)
{
    service_name result(original_name);
    if (result == service_name("") && client_id_string == "bar")
    {
        result = service_name("mail");
    }
    return result;
}

template <typename TokenUserData>
bool auth_type_xiva_token(const TokenUserData& data)
{
    // HACK: guess authorization type by looking at data.uid:
    // it should be empty when xiva_token authorization was used
    // and not empty for oauth (possibly cookies, if cookies get
    // implemented as a separate auth_step)
    // TODO: remove this when we remove oauth
    return data.uid.empty();
}

inline const string& service_name(const string& name)
{
    return name;
}

inline const string& service_name(const service_with_filter& service)
{
    return service.name;
}

inline operation::result is_correct_uid(const string& uid, const string& service)
{
    return uid.find(":") == string::npos || service == "autoru" || service == "realty" ?
        operation::success :
        "uid can't contain \":\"";
}

template <typename ServiceArg>
inline operation::result is_correct_uids(
    const std::vector<string>& uids,
    const std::vector<ServiceArg>& services)
{
    static const std::set<string> special_services = { "autoru", "realty" };
    for (auto& service : services)
    {
        if (special_services.count(service_name(service)))
        {
            return operation::success;
        }
    }
    for (auto& uid : uids)
    {
        if (auto result = is_correct_uid(uid, ""); !result)
        {
            return result;
        }
    }
    return operation::success;
}

inline bool connected_message_enabled(const string& service)
{
    static const std::set<string> enabled_for = { "maps-auto-push",
                                                  "messenger",
                                                  "messenger-prod",
                                                  "test",
                                                  "tst1",
                                                  "tst2",
                                                  "telemost-test",
                                                  "telemost-test2",
                                                  "autoru-c2b-auction",
                                                  "telemost-mediator",
                                                  "telemost-mediator-2",
                                                  "telemost-mediator-3",
                                                  "telemost-mediator-4",
                                                  "telemost-mediator-yt" };
    return enabled_for.count(service);
}

}}}
