#pragma once

#include <ymod_webserver/response.h>
#include <ymod_webserver/codes.h>

namespace yxiva { namespace web {

template <typename NextHandler>
class http_method_handler
{
    typedef typename std::decay<NextHandler>::type handler_type;

public:
    http_method_handler(ymod_webserver::methods::http_method method, handler_type next_handler)
        : method(method), next(std::move(next_handler))
    {
    }

    template <typename... Args>
    void operator()(const ymod_webserver::http::stream_ptr& stream, Args&&... args)
    {
        if (stream->request()->method != method)
        {
            stream->result(ymod_webserver::codes::method_not_allowed);
            return;
        }
        next(stream, std::forward<Args>(args)...);
    }

private:
    ymod_webserver::methods::http_method method;
    handler_type next;
};

template <typename Handler>
http_method_handler<Handler> POST_handler(Handler&& next_handler)
{
    return http_method_handler<Handler>(
        ymod_webserver::methods::mth_post, std::forward<Handler>(next_handler));
}

template <typename Handler>
http_method_handler<Handler> GET_handler(Handler&& next_handler)
{
    return http_method_handler<Handler>(
        ymod_webserver::methods::mth_get, std::forward<Handler>(next_handler));
}

}}