#include "common.h"

namespace yxiva::web::idm {

std::tuple<operation::result, string, string, string> parse_role(const string& role)
{
    json_value json_role;
    if (auto res = json_role.parse(role)) return { "json parse error", "", "", "" };

    return { "",
             json_role["project"].to_string(),
             json_role["environment"].to_string(),
             json_role["role"].to_string() };
}

std::tuple<operation::result, uint32_t> parse_login(const string& login)
{
    uint32_t id;
    if (!boost::conversion::try_lexical_convert(login, id)) return { "wrong login", 0 };
    return { "", id };
}

operation::result validate_args(
    const string& subject_type,
    const string& environment,
    const string& role_type)
{
    if (subject_type != "tvm_app") return "wrong subject_type";

    if (environment != "sandbox" && environment != "corp" && environment != "production")
        return "wrong environment";

    if (role_type != "publisher" && role_type != "subscriber") return "wrong role";

    return {};
}

}
