#pragma once

#include "web/types.h"
#include "json_response.h"
#include "web/find_deps.h"
#include "web/stream_helpers.h"
#include <yplatform/coroutine.h>

namespace yxiva::web::idm {

std::tuple<operation::result, string, string, string> parse_role(const string& role);
std::tuple<operation::result, uint32_t> parse_login(const string& login);
operation::result validate_args(
    const string& subject_type,
    const string& environment,
    const string& role_type);

template <typename Stream>
inline void send_ok_response(Stream stream)
{
    stream->result(ymod_webserver::codes::ok, R"({"code": 0})");
}

template <typename Stream>
inline void send_bad_request(Stream stream, const operation::result& res)
{
    stream->ctx()->custom_log_data["reason"] = res.error_reason;
    web::send_bad_request(stream, res.error_reason);
}

template <typename Stream>
inline void send_internal_error(Stream stream, const operation::result& res)
{
    stream->ctx()->custom_log_data["reason"] = res.error_reason;
    web::send_internal_error(stream, "", res.error_reason);
}

}
