#pragma once

#include "json_response.h"
#include "settings.h"
#include "web/find_deps.h"
#include "web/stream_helpers.h"
#include "web/types.h"

namespace yxiva::web::idm {

namespace detail {
template <typename Stream>
struct list_task;
}

struct info
{
    std::shared_ptr<settings> settings_ptr;

    info(std::shared_ptr<settings> st) : settings_ptr(st)
    {
    }

    template <typename Stream>
    void operator()(Stream stream)
    {
        auto task =
            std::make_shared<detail::list_task<Stream>>(generate_tree, settings_ptr, stream);
        task->run();
    }
};

struct get_all_roles
{
    std::shared_ptr<settings> settings_ptr;

    get_all_roles(std::shared_ptr<settings> st) : settings_ptr(st)
    {
    }

    template <typename Stream>
    void operator()(Stream stream)
    {
        auto task = std::make_shared<detail::list_task<Stream>>(list_roles, settings_ptr, stream);
        task->run();
    }
};

namespace detail {

template <typename Stream>
struct list_task : std::enable_shared_from_this<list_task<Stream>>
{
    using response_formatter = std::function<json_value(const services_type&)>;

    response_formatter format_response;
    std::shared_ptr<settings> settings_ptr;
    Stream stream;

    list_task(
        response_formatter format_response,
        std::shared_ptr<settings> settings_ptr,
        Stream stream)
        : format_response(format_response), settings_ptr(settings_ptr), stream(stream)
    {
    }

    void run()
    {
        namespace p = std::placeholders;
        auto service_manager_ptr = yplatform::find<service_manager>(settings_ptr->service_manager);
        service_manager_ptr->get_all_services(
            stream->request()->context,
            std::bind(
                &list_task<Stream>::service_manager_handler, shared_from(this), p::_1, p::_2));
    }

    void service_manager_handler(const operation::result& res, services_type services)
    {
        if (!res) return send_internal_error(stream, "idm list task failed", res.error_reason);

        auto response = format_response(services);
        stream->result(ymod_webserver::codes::ok, response.pretty_stringify());
    }
};

}

}
