#include "json_response.h"

#include <yxiva/core/platforms.h>
#include <yplatform/encoding/base64.h>
#include <yplatform/hash/sha1.h>

namespace yxiva::web::idm {

json_value make_tree_node(const service_properties& service);
json_value make_aliases(const service_properties& service);

json_value generate_tree(const services_type& services)
{
    json_value result;
    result["code"] = 0;
    auto&& root = result["roles"];
    root["slug"] = "project";
    root["name"] = "project";
    auto&& service_nodes = root["values"];
    service_nodes.set_object();
    for (auto&& service_ptr : services)
    {
        auto&& props = service_ptr->properties;
        service_nodes[props.name] = make_tree_node(props);
    }
    return result;
}

json_value make_tree_node(const service_properties& service)
{
    json_value node;
    node["name"] = service.name;
    auto&& environments = node["roles"];
    environments["slug"] = "environment";
    environments["name"] = "environment";
    for (auto&& env_name : std::vector<string>{ "sandbox", "corp", "production" })
    {
        auto&& env = environments["values"][env_name];
        env["name"] = env_name;
        auto&& roles = env["roles"];
        roles["slug"] = "role";
        roles["name"] = "role";
        roles["values"]["subscriber"] = "subscriber";
        roles["values"]["publisher"] = "publisher";
    }
    // Store owner info as an alias which is the only
    // attribute available in IDM workflow.
    node["aliases"] = make_aliases(service);
    return node;
}

json_value make_aliases(const service_properties& service)
{
    json_value aliases;
    auto&& alias = aliases.push_back();
    alias["type"] = "default";
    // Include service name to prevent treating the owner ID as a real alias for IDM role.
    alias["name"] = service.name + "%%" + service.owner();
    return aliases;
}

json_value make_user(
    const string& role,
    const string& project,
    const string& env,
    const tvm_app_info& tvm_app);

json_value list_roles(const services_type& services)
{
    json_value result;
    result["code"] = 0;
    auto&& users = result["users"];
    users.set_array();
    for (auto&& service_ptr : services)
    {
        auto&& props = service_ptr->properties;
        for (auto&& [env, tvm_apps] : props.tvm_publishers)
        {
            for (auto&& tvm_app : tvm_apps)
                users.push_back(make_user("publisher", props.name, env, tvm_app));
        }
        for (auto&& [env, tvm_apps] : props.tvm_subscribers)
        {
            for (auto&& tvm_app : tvm_apps)
                users.push_back(make_user("subscriber", props.name, env, tvm_app));
        }
    }
    return result;
}

json_value make_user(
    const string& role,
    const string& project,
    const string& env,
    const tvm_app_info& tvm_app)
{
    json_value user;
    user["login"] = std::to_string(tvm_app.id);
    user["subject_type"] = "tvm_app";
    auto&& user_role = user["roles"].push_back();
    user_role["project"] = project;
    user_role["environment"] = env;
    user_role["role"] = role;
    return user;
}

}
