#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/tvm.h>

namespace yxiva::web::idm {

struct settings
{
    void load(const yplatform::ptree& conf)
    {
        enabled = conf.get<bool>("enabled", false);
        http_client = conf.get<string>("http_client");
        http_options.timeouts.connect = conf.get<time_traits::duration>("connect_timeout");
        http_options.timeouts.total = conf.get<time_traits::duration>("total_timeout");
        service_manager = conf.get<string>("service_manager");
        tvm_info_url = conf.get<string>("tvm_info_url");
        tvm.parse_ptree(conf.get_child("tvm"));
    }

    bool enabled = false;
    string http_client;
    yhttp::options http_options;
    string service_manager;
    string tvm_info_url;
    tvm_checker_settings tvm;
};

}
