#pragma once

#include <yplatform/module.h>
#include "web/formatters/kit.h"
#include <yxiva/core/request_stats.h>
#include "web/settings.h"
#include "websocket_rpc/main_handler.h"
#include "webpushapi/catalogue.h"

namespace yxiva { namespace web {

class impl : public yplatform::module
{
public:
    impl(const yplatform::ptree& ptree);

    void init();
    void start();
    void reload(const yplatform::ptree& ptree); // Updates only some settings.
    void stop();
    void fini(void);

    string make_sign(const string& data, time_t expired) const;

    yplatform::ptree get_stats() const
    {
        auto result = stats_->to_ptree();
        result.put_child("rpc", websocketapi_rpc_handler_->get_stats().to_ptree());
        result.put_child("webpushapi", webpushapi_rpc_handler_->get_stats().to_ptree());
        return result;
    }

    bool filter_accepted(ymod_webserver::request& req);
    std::string custom_key_extractor(ymod_webserver::http::stream_ptr stream);
    settings_ptr get_settings()
    {
        return settings_;
    }

private:
    void bind_http_api();
    void bind_back_api();
    void bind_v1_api();
    void bind_v2_api();
    void bind_webpush_api();
    void bind_webui_api();
    void bind_idm_api();

    settings_ptr settings_;
    std::shared_ptr<request_stats> stats_;
    formatters::kit formatters_kit_;
    std::shared_ptr<websocket_rpc::main_handler> websocketapi_rpc_handler_;
    std::shared_ptr<websocket_rpc::main_handler> webpushapi_rpc_handler_;
    std::shared_ptr<webpushapi::catalogue> webpushapi_catalogue_;
};

}}
