#pragma once

#include <yxiva/core/types.h>
#include <yplatform/net/buffers/chunk.h>
#include <yplatform/net/streambuf.h>

namespace yxiva { namespace web {

inline yplatform::net::buffers::const_chunk_buffer load_text_file(const string& path)
{
    yplatform::net::chunk_streambuf buf;
    {
        std::ostream stream(&buf);
        std::ifstream rf(path.c_str());
        if (!rf.is_open() || !rf.good())
            throw std::runtime_error("can`t load text file '" + path + "'");
        rf >> std::noskipws;
        std::copy(
            std::istream_iterator<char>(rf),
            std::istream_iterator<char>(),
            std::ostream_iterator<char>(stream));
    }
    return buf.release_buffer();
}

}}
