#pragma once

#include <yxiva/core/json.h>
#include <yxiva/core/types.h>

namespace yxiva::web {

struct ping_message
{
    time_duration ping_interval;

    json_value to_json() const
    {
        json_value content;
        content["operation"] = "ping";
        int64_t interval = time_traits::duration_cast<seconds>(ping_interval).count();
        content["server-interval-sec"] = interval;
        content["message"] = "";
        return content;
    }

    string to_string() const
    {
        return to_json().stringify();
    }
};

struct error_message
{
    string error;

    json_value to_json() const
    {
        json_value content;
        content["operation"] = "xivaws-error";
        content["message"] = error;
        return content;
    }

    string to_string() const
    {
        return to_json().stringify();
    }
};

struct position_message
{
    user_id uid;
    service_name service;
    local_id_t pos = 0;
    unsigned count = 0;

    json_value to_json() const
    {
        json_value content;
        content["uid"] = static_cast<string>(uid);
        content["service"] = static_cast<string>(service);
        content["operation"] = "precise-position";
        content["position"] = pos;
        content["count"] = count;
        content["message"] = "";
        return content;
    }

    string to_string() const
    {
        return to_json().stringify();
    }
};

struct connected_message
{
    user_id uid;
    service_name service;

    json_value to_json() const
    {
        json_value content;
        content["uid"] = static_cast<string>(uid);
        content["service"] = static_cast<string>(service);
        content["operation"] = "subscribed";
        content["event"] = "subscribed";
        content["message"] = "";
        return content;
    }

    string to_string() const
    {
        return to_json().stringify();
    }
};

struct disconnected_message
{
    user_id uid;
    service_name service;

    json_value to_json() const
    {
        json_value content;
        content["uid"] = static_cast<string>(uid);
        content["service"] = static_cast<string>(service);
        content["operation"] = "disconnected";
        content["event"] = "disconnected";
        content["message"] = "";
        return content;
    }

    string to_string() const
    {
        return to_json().stringify();
    }
};

typedef std::
    tuple<ping_message, error_message, position_message, connected_message, disconnected_message>
        xivaws_special_messages;

}