#pragma once

#include <yxiva/core/iabstract.h>
#include <yxiva/core/types.h>
#include <ymod_httpclient/response_handler.h>

namespace yxiva { namespace web {

class http_handler_no_read_body : public ymod_http_client::response_handler
{
public:
    http_handler_no_read_body() : success_(false), code_(0)
    {
    }

    ymod_http_client::handler_version version() const
    {
        return ymod_http_client::handler_version_already_parse_body;
    }

    void set_code(int code, const string& description)
    {
        code_ = code;
        description_ = description;
        success_ = (code == 200);
    }

    virtual void handle_data(const char*, unsigned long long)
    {
    }

    bool success() const
    {
        return success_;
    }

    int code() const
    {
        return code_;
    }

    const string& description() const
    {
        return description_;
    }

private:
    bool success_;
    int code_;
    string description_;
};

class http_handler_read_body : public http_handler_no_read_body
{
public:
    virtual void handle_data(const char* data, unsigned long long size)
    {
        data_.append(data, size);
    }

    const string& data() const
    {
        return data_;
    }

private:
    string data_;
};

}}