#pragma once

#include <ymod_webserver/request.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/websocket.h>

#include <yxiva/core/types.h>
#include "web/formatters/kit.h"

#include "web/future_close.h"
#include "web/settings.h"
#include "subscriber_factory.h"

namespace yxiva { namespace web { namespace methods {

class subscribe_process : public iabstract
{
public:
    subscribe_process(
        ymod_webserver::request_ptr req,
        time_duration ping_interval,
        future_close future_session_closed,
        subscriber_factory_t subscriber_factory);

    virtual void send_retry_after(std::time_t time) = 0;
    virtual void send_sign_error() = 0;
    virtual void send_auth_failed(const string& info) = 0;
    virtual void send_bad_request(const string& info, const string& priv_info) = 0;
    virtual timer_ptr make_timer() = 0;

    virtual time_duration ping_interval()
    {
        return ping_interval_;
    }

    future_close future_session_close()
    {
        return future_session_closed_;
    }

    web_subscriber_ptr create_subscriber(
        task_context_ptr ctx,
        formatters::formatter_ptr formatter,
        std::time_t timestamp,
        const string& client_id)
    {
        return subscriber_factory_(ctx, formatter, timestamp, client_id);
    }

protected:
    ymod_webserver::request_ptr req_;
    time_duration ping_interval_;
    future_close future_session_closed_;
    subscriber_factory_t subscriber_factory_;
};

typedef shared_ptr<subscribe_process> subscribe_process_ptr;

class subscribe_process_http : public subscribe_process
{
public:
    subscribe_process_http(
        ymod_webserver::request_ptr req,
        ymod_webserver::response_ptr response,
        time_duration ping_interval,
        future_close future_session_closed,
        subscriber_factory_t subscriber_factory);

    virtual void send_retry_after(std::time_t time);
    virtual void send_sign_error();
    virtual void send_auth_failed(const string& info);
    virtual void send_bad_request(const string& info, const string& priv_info);
    virtual timer_ptr make_timer();

private:
    ymod_webserver::response_ptr response_;
};

class subscribe_process_websocket : public subscribe_process
{
public:
    subscribe_process_websocket(
        ymod_webserver::request_ptr req,
        ymod_webserver::websocket::output_stream_ptr output_stream,
        time_duration ping_interval,
        future_close future_session_closed,
        subscriber_factory_t subscriber_factory);

    virtual void send_retry_after(std::time_t time);
    virtual void send_sign_error();
    virtual void send_auth_failed(const string& info);
    virtual void send_bad_request(const string& info, const string& priv_info);
    virtual timer_ptr make_timer();

private:
    ymod_webserver::websocket::output_stream_ptr output_stream_;
};

}}}