#include "subscriber_factory.h"

#include "web/sse_subscriber.h"
#include "web/websocket_subscriber.h"

namespace yxiva { namespace web { namespace methods {

void send_sse_headers(ymod_webserver::response_ptr resp)
{
    resp->set_code(ymod_webserver::codes::ok);
    resp->add_header("Access-Control-Allow-Origin", "*");
    resp->add_header(
        "Cache-Control",
        "max-age=0, must-revalidate, proxy-revalidate, no-cache, no-store, private");
    resp->add_header("Expires", "Thu, 01 Jan 1970 00:00:01 GMT");
    resp->add_header("Pragma", "no-cache");
    resp->set_content_type("text", "event-stream");
    resp->set_connection(false);
}

web_subscriber_ptr create_sse_subscriber(
    task_context_ptr ctx,
    ymod_webserver::response_ptr resp,
    formatters::formatter_ptr formatter,
    std::time_t timestamp,
    const string& client_id)
{
    send_sse_headers(resp);
    yplatform::net::streamable_ptr stream = resp->result_chunked();
    shared_ptr<sse_subscriber> subscriber =
        ::yxiva::make_shared<sse_subscriber>(ctx, stream, formatter, timestamp, client_id);
    return subscriber;
}

web_subscriber_ptr create_websocket_subscriber(
    task_context_ptr ctx,
    ymod_webserver::websocket::output_stream_ptr output_stream,
    formatters::formatter_ptr formatter,
    std::time_t timestamp,
    const time_duration& inactive_timeout,
    const string& client_id)
{
    shared_ptr<websocket_subscriber> subscriber = ::yxiva::make_shared<websocket_subscriber>(
        ctx, output_stream, formatter, timestamp, inactive_timeout, client_id);
    subscriber->init();
    return subscriber;
}

}}}
