#pragma once

#include <ymod_webserver/request.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/websocket.h>

#include <yxiva/core/types.h>
#include "web/formatters/kit.h"

#include "web/future_close.h"
#include "web/settings.h"
#include "web/base_web_subscriber.h"

namespace yxiva { namespace web { namespace methods {

web_subscriber_ptr create_sse_subscriber(
    task_context_ptr ctx,
    ymod_webserver::response_ptr resp,
    formatters::formatter_ptr formatter,
    std::time_t timestamp,
    const string& client_id);

web_subscriber_ptr create_websocket_subscriber(
    task_context_ptr ctx,
    ymod_webserver::websocket::output_stream_ptr output_stream,
    formatters::formatter_ptr formatter,
    std::time_t timestamp,
    const time_duration& inactive_timeout,
    const string& client_id);

typedef boost::function<web_subscriber_ptr(
    task_context_ptr ctx,
    formatters::formatter_ptr formatter,
    std::time_t timestamp,
    const string& client_id)>
    subscriber_factory_t;

}}}