#include "origin_domains.h"
#include <fstream>

namespace yxiva { namespace web {

namespace {

inline bool matches(const std::string& domain, const std::string& pattern)
{
    if (domain.size() < pattern.size()) return false;

    if (pattern.size() && pattern[0] == '.')
    {
        return std::equal(pattern.rbegin(), pattern.rend(), domain.rbegin());
    }
    else
    {
        return domain == pattern;
    }
}

}

void origin_domains_list::add(const string& domain)
{
    if (domain.empty()) return;
    items_.push_back(domain);
}

std::pair<bool, string> origin_domains_list::check_allowed(const string& domain) const
{
    using std::make_pair;
    if (items_.empty()) return make_pair(true, "*");
    for (auto i = items_.begin(), i_end = items_.end(); i != i_end; ++i)
    {
        if (matches(domain, *i))
        {
            return make_pair(true, *i);
        }
    }
    return make_pair(false, "");
}

void load_origin_domains(const string& path, origin_domains_list& dst)
{
    if (path.empty()) return;
    std::ifstream rf(path.c_str());
    if (!rf.is_open() || !rf.good()) throw std::runtime_error("can`t load origin domains");
    string domain;
    while (std::getline(rf, domain))
    {
        dst.add(domain);
    }
}

}}
