#pragma once

#include <yxiva/core/operation_result.h>

namespace yxiva { namespace web {

struct push_ack
{
    string send_context;
    string transit_id;
    string client;
    string service;
};

inline operation::result parse_push_ack(const json_value& value, push_ack& ack)
{
    string reaction = json_get<string>(value, "reaction", "");
    if (reaction != "ack")
    {
        return "ignoring reaction \"" + reaction + "\"";
    }

    string parsed = json_get<string>(value, "parsed", "");
    string server_notify_id = json_get<string>(value, "server_notify_id", "");
    std::vector<string> server_notify_id_decoded;
    boost::split(server_notify_id_decoded, server_notify_id, boost::is_any_of(":"));
    if (server_notify_id_decoded.size() != 4)
    {
        return "message from client parse error: bad server_notify_id \"" + server_notify_id + "\"";
    }

    ack = push_ack{ server_notify_id_decoded[0],
                    server_notify_id_decoded[1],
                    server_notify_id_decoded[2],
                    server_notify_id_decoded[3] };

    return {};
}

}}
