#pragma once

#include <ymod_webserver/response.h>
#include <ymod_webserver/codes.h>

namespace yxiva { namespace web {

template <typename NextHandler>
class secure_connection_handler
{
    typedef typename std::decay<NextHandler>::type handler_type;

public:
    secure_connection_handler(NextHandler&& next_handler)
        : next(std::forward<NextHandler>(next_handler))
    {
    }

    template <typename Stream, typename... Args>
    void operator()(const Stream& stream, Args&&... args)
    {
        if (!stream->is_secure())
        {
            stream->result(ymod_webserver::codes::forbidden, "Secure connection required");
            return;
        }
        next(stream, std::forward<Args>(args)...);
    }

private:
    handler_type next;
};

template <typename Handler>
secure_connection_handler<Handler> secure_connection(Handler&& next_handler)
{
    return secure_connection_handler<Handler>(std::forward<Handler>(next_handler));
}

}}
