#include "sse_subscriber.h"

#include <boost/pointer_cast.hpp>
#include <yplatform/find.h>
#include <processor/interface.h>

namespace yxiva { namespace web {

static const string NAME = string("ss_event");

void sse_subscriber::impl_notify_text(const string& message)
{
    yplatform::net::streamable_ptr stream_copy = stream();
    if (!stream_copy) return;
    stream_copy->client_stream() << "data: " << message << "\r\n\r\n";
    // hack for opera: extra ping message
    stream_copy->client_stream() << "data: { \"operation\": \"opera-fix\" }\r\n\r\n";
}

void sse_subscriber::ping(const ping_message& message)
{
    yplatform::net::streamable_ptr stream_copy = stream();
    if (!stream_copy) return;
    stream_copy->client_stream() << "data: " << message.to_string() << "\r\n\r\n";
    // hack for opera: extra ping message
    stream_copy->client_stream() << "data: { \"operation\": \"opera-fix\" }\r\n\r\n";
}

void sse_subscriber::notify_error(const error_message& message)
{
    yplatform::net::streamable_ptr stream_copy = stream();
    if (!stream_copy) return;
    stream_copy->client_stream() << "data: " << message.to_string() << "\r\n\r\n";
    // hack for opera: extra ping message
    stream_copy->client_stream() << "data: { \"operation\": \"opera-fix\" }\r\n\r\n";
}

void sse_subscriber::close()
{
    reset_stream();
}

void sse_subscriber::notify_position(const position_message& message)
{
    if (auto stream_copy = stream())
    {
        stream_copy->client_stream() << "data: " << message.to_string() << "\r\n\r\n";
        // hack for opera: extra ping message
        stream_copy->client_stream() << "data: { \"operation\": \"opera-fix\" }\r\n\r\n";
    }
}

const string& sse_subscriber::name() const
{
    return NAME;
}

yplatform::net::streamable_ptr sse_subscriber::stream()
{
    scoped_lock lock(mux_);
    return stream_;
}

void sse_subscriber::reset_stream()
{
    scoped_lock lock(mux_);
    if (stream_)
    {
        stream_.reset();
    }
}

}}
