#pragma once

#include <memory>
#include <yplatform/net/streamable.h>
#include "web/settings.h"
#include <processor/interface.h>
#include "base_web_subscriber.h"

namespace yxiva { namespace web {

class sse_subscriber : public base_web_subscriber
{
public:
    sse_subscriber(
        task_context_ptr context,
        yplatform::net::streamable_ptr stream,
        formatters::formatter_ptr formatter,
        std::time_t sign_expiration,
        const string& client_id)
        : base_web_subscriber(context, formatter, sign_expiration, client_id), stream_(stream)
    {
    }

    void notify_position(const position_message&) override;
    void notify_error(const error_message&) override;
    void ping(const ping_message&) override;

    void close() override;

protected:
    void impl_notify_text(const string& message) override;
    const string& name() const override;

private:
    yplatform::net::streamable_ptr stream();
    void reset_stream();

    mutex mux_;
    yplatform::net::streamable_ptr stream_;
};

}}
