#pragma once

#include <ymod_webserver/request.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/websocket.h>
#include <ymod_webserver/expirable_stream.h>
#include <ymod_webserver/codes.h>
#include <yxiva/core/types.h>
#include <yxiva/core/json.h>

namespace yxiva { namespace web {

typedef ymod_webserver::request_ptr request_ptr;
typedef ymod_webserver::http::stream_ptr http_stream_ptr;
typedef ymod_webserver::http::expirable_stream_ptr expirable_stream_ptr;
typedef ymod_webserver::websocket::output_stream websocket_stream;
typedef ymod_webserver::websocket::stream_ptr websocket_stream_ptr;
typedef ymod_webserver::websocket::stream_weak_ptr websocket_stream_weak_ptr;
namespace http_codes = ymod_webserver::codes;
namespace websocket_codes = ymod_webserver::websocket::codes;

// Wraps shared/weak ptr to websocket stream or websocket rpc stream.
template <typename StreamPtr>
class universal_stream_wrapper
{
public:
    typedef StreamPtr ptr_type;
    typedef typename StreamPtr::element_type native_type;

    universal_stream_wrapper(ptr_type ptr) : ptr_(ptr)
    {
    }

    template <typename U = StreamPtr>
    bool is_alive() const
    {
        if constexpr (std::is_same_v<U, websocket_stream_weak_ptr>)
        {
            auto locked = ptr_.lock();
            return locked ? locked->is_open() : false;
        }
        else if constexpr (std::is_same_v<U, websocket_stream_ptr>)
        {
            return ptr_->is_open();
        }
    }

    auto operator-> () const
    {
        return resolve();
    }

private:
    template <typename U = StreamPtr>
    auto resolve() const
    {
        if constexpr (std::is_same_v<U, websocket_stream_weak_ptr>)
        {
            auto locked = ptr_.lock();
            if (!locked)
            {
                throw std::runtime_error("invalid stream");
            }
            return locked;
        }
        else if constexpr (std::is_same_v<U, websocket_stream_ptr>)
        {
            return ptr_;
        }
    }

    ptr_type ptr_;
};

template <typename T>
inline bool is_alive(const universal_stream_wrapper<T>& stream)
{
    return stream.is_alive();
}

}}
