#include <yplatform/util/tuple_unpack.h>
#include <yplatform/coroutine.h>
#include <memory>
#include <tuple>

namespace yxiva { namespace web {

// Create shared object of type T and spawns it as an yplatform coroutine.
template <typename T>
struct coroutine
{
    // Inherits from T to use aggregate initialization within make_shared.
    struct initializer : T
    {
        template <typename... Args>
        initializer(Args&&... args) : T{ std::forward<Args>(args)... }
        {
        }
    };

    template <typename... Args>
    void operator()(Args&&... args)
    {
        std::shared_ptr<T> coro = std::make_shared<initializer>(std::forward<Args>(args)...);
        yplatform::spawn(coro);
    }
};

// Attach saved arguments and pass to a wrapped handler transparently.
template <typename Handler, typename... PassArgs>
struct pass
{
    pass(Handler&& handler, PassArgs... args)
        : handler(std::forward<Handler>(handler)), stored_args(std::move(args)...)
    {
    }

    template <typename... Args>
    void operator()(Args&&... args)
    {
        yplatform::util::call_with_tuple_args(handler, stored_args, std::forward<Args>(args)...);
    }

    std::decay_t<Handler> handler;
    std::tuple<PassArgs...> stored_args;
};

}}
