#include "service_list_parser.h"

namespace yxiva { namespace web {

namespace detail {

bool valid_char_in_service_name(char c)
{
    return isalnum(c) || c == '-' || c == '_';
}

bool valid_char_in_tag_name(char c)
{
    return isalnum(c) || c == '_' || c == '.';
}
void append_tag(service_with_tags& dest, const string& tag, bool new_set)
{
    if (dest.tags.size() == 0 || new_set)
    {
        dest.tags.push_back(std::vector<string>());
    }

    dest.tags.back().push_back(tag);
}

}

std::vector<service_with_tags> parse_service_list_with_tags(
    const string& source,
    unsigned max_tags_per_service)
{
    std::vector<service_with_tags> result;

    enum class state_t
    {
        read_service,
        read_tag
    };
    state_t state = state_t::read_service;
    auto begin = source.begin();
    auto end = source.end();
    auto start = source.begin();
    unsigned tags_count = 0;
    for (auto pos = begin;; ++pos)
    {
        if (state == state_t::read_service)
        {
            // ":" starts tag list, "," starts new service
            if (pos == end || *pos == ':' || *pos == ',')
            {
                if (start == end) break;
                if (start == pos)
                {
                    throw std::domain_error(
                        "empty service name at " + boost::lexical_cast<string>(pos - begin));
                }

                // append service
                result.push_back(service_with_tags());
                result.back().service = string(start, pos);

                if (pos == end) break;

                if (*pos == ':') state = state_t::read_tag;

                // continue from pos + 1
                start = pos + 1;
            }
            else
            {
                if (!detail::valid_char_in_service_name(*pos))
                {
                    throw std::domain_error(
                        "not valid character at " + boost::lexical_cast<string>(pos - begin));
                }
            }
        }
        else if (state == state_t::read_tag)
        {
            // "+" or "*" start another tag, "," starts new service
            if (pos == end || *pos == '+' || *pos == '*' || *pos == ',')
            {
                if (start == end) break;
                if (start == pos)
                {
                    throw std::domain_error(
                        "empty tag name at " + boost::lexical_cast<string>(pos - begin));
                }

                if (tags_count >= max_tags_per_service)
                {
                    throw std::domain_error("tags count constraint violated");
                }

                detail::append_tag(result.back(), string(start, pos), *(start - 1) == '+');
                ++tags_count;

                if (pos == end) break;

                if (*pos == ',')
                {
                    state = state_t::read_service;
                    tags_count = 0;
                }

                // continue from pos + 1
                start = pos + 1;
            }
            else
            {
                if (!detail::valid_char_in_tag_name(*pos))
                {
                    throw std::domain_error(
                        "not valid character at " + boost::lexical_cast<string>(pos - begin));
                }
            }
        }
    }

    return result;
}

}}