#pragma once

#include "encoding.h"
#include "common.h"

namespace yxiva { namespace web { namespace webpushapi {

class catalogue
    : public std::enable_shared_from_this<catalogue>
    , public yplatform::log::contains_logger
{
public:
    using stream_ptr = std::shared_ptr<websocket_rpc::stream>;
    using stream_wptr = std::weak_ptr<websocket_rpc::stream>;

    // New stream always replaces streams with same uidset.
    void add(const string& uidset, const stream_ptr& stream)
    {
        auto weak_self = std::weak_ptr<catalogue>(shared_from_this());
        auto weak_stream = stream_wptr(stream);
        stream->set_close_hook([this, weak_self, uidset, weak_stream](uint16_t, const string&) {
            if (auto self = weak_self.lock())
            {
                if (auto stream = weak_stream.lock())
                {
                    // TODO log
                    del(uidset);
                }
            }
        });
        scoped_lock guard(m_);
        YLOG_CTX_LOCAL(stream->ctx(), info) << "webpushapi::catalogue::add";
        clients.insert({ uidset, stream });
    }

    void del(const string& uidset)
    {
        scoped_lock guard(m_);
        clients.erase(uidset);
    }

    // Delete item only if stream matches by ctx.
    void del(const string& uidset, const yplatform::task_context_ptr& ctx)
    {
        scoped_lock guard(m_);
        auto it = clients.find(uidset);
        if (it != clients.end())
        {
            auto&& stream = it->second;
            if (stream->ctx() == ctx) clients.erase(it);
            YLOG_CTX_LOCAL(ctx, info) << "webpushapi::catalogue::del";
        }
    }

    stream_ptr find(const string& uidset)
    {
        scoped_lock guard(m_);
        auto it = clients.find(uidset);
        return it != clients.end() ? it->second : stream_ptr();
    }

    std::vector<string> list()
    {
        std::vector<string> uidset_list;
        scoped_lock guard(m_);
        uidset_list.reserve(clients.size());
        for (auto& pair : clients)
        {
            uidset_list.push_back(pair.first);
        }
        return uidset_list;
    }

private:
    mutex m_;
    std::map<string, stream_ptr> clients;
};

}}}
