#pragma once

#include "encoding.h"
#include "common.h"

namespace yxiva { namespace web { namespace webpushapi {

void list(
    settings_ptr settings,
    const std::shared_ptr<websocket_rpc::stream>& stream,
    const string& subset)
{
    string uidsetid = decode_uidsetid_from_subset(subset);
    if (uidsetid.empty())
    {
        return send_bad_request(stream, "invalid subscription set");
    }
    find_hubrpc()->async_get(
        stream->ctx(),
        uidsetid,
        "/uidset/list",
        { { "uidset", uidsetid }, { "service", settings->webpushapi.service } },
        handle_hub_list_json(stream, [stream](const std::vector<sub_t>& subs) {
            json_value result(json_type::tarray);
            for (auto& sub : subs)
            {
                json_value item;
                item["subscription"] = encode_subscription(sub.uid);
                item["ttl"] = sub.ttl * 1000;
                result.push_back(std::move(item));
            }
            stream->result_json(http_codes::ok, result);
        }));
}

}}}
