#pragma once

#include "encoding.h"
#include "common.h"
#include "catalogue.h"

namespace yxiva { namespace web { namespace webpushapi {

void list_catalogue(std::shared_ptr<catalogue> catalogue, const http_stream_ptr& stream)
{
    json_value result(json_type::tarray);
    for (auto& item : catalogue->list())
        result.push_back(item);
    stream->result(http_codes::ok, result.stringify());
}

}}}
