#pragma once

#include "encoding.h"
#include "common.h"
#include "catalogue.h"

namespace yxiva { namespace web { namespace webpushapi {

void monitor(
    settings_ptr settings,
    std::shared_ptr<catalogue> catalogue,
    const std::shared_ptr<websocket_rpc::stream>& stream,
    const string& subset)
{
    auto&& log_data = stream->ctx()->custom_log_data;
    log_data["api_group"] = "webpushapi subscriptions";
    log_data["subset"] = subset;

    auto uidsetid = decode_uidsetid_from_subset(subset);
    if (uidsetid.empty())
    {
        return send_bad_webpushapi_request(stream, "monitor", "invalid subscription set");
    }
    log_data["uidsetid"] = uidsetid;
    catalogue->add(uidsetid, stream);
    find_hubrpc()->async_get(
        stream->ctx(),
        uidsetid,
        "/uidset/update_callback",
        { { "uidset", uidsetid },
          { "service", settings->webpushapi.service },
          { "callback", settings->webpushapi.callback } },
        [settings, catalogue, stream, uidsetid, &log_data](
            const boost::system::error_code& ec, yhttp::response response) {
            if (ec || response.status != 200)
            {
                catalogue->del(uidsetid, stream->ctx());
                log_data["api_result"] = "monitor failed";
                log_data["error"] = "update_callback " + format_http_error(ec, response.status);
                handle_default_hub_codes(stream, ec, response);
                return;
            }
            log_data["api_result"] = "monitor success";
            stream->result(http_codes::ok, "OK");
        });
}

}}}
