#pragma once

#include "web/stream_helpers.h"
#include <yxiva/core/types.h>
#include <yplatform/util/sstream.h>

namespace yxiva { namespace web { namespace webpushapi {

template <typename Stream>
inline void send_bad_webpushapi_request(
    const Stream& stream,
    const string& action,
    const string& error,
    const string& internal_info = {})
{
    stream->ctx()->custom_log_data["api_result"] = action + " failed";
    yplatform::sstream err(
        stream->ctx()->custom_log_data["error"], error.size() + internal_info.size() + 2);
    err << error;
    if (internal_info.size()) err << ": " << internal_info;
    send_bad_request(stream, error, internal_info);
}

}}}
