#pragma once

#include "encoding.h"
#include "common.h"

namespace yxiva { namespace web { namespace webpushapi {

void unsubscribe(
    settings_ptr settings,
    const std::shared_ptr<websocket_rpc::stream>& stream,
    const string& subscription)
{
    auto&& log_data = stream->ctx()->custom_log_data;
    log_data["api_group"] = "webpushapi subscriptions";
    log_data["subscription"] = subscription;

    string uidsetid, uid;
    auto decoded = decode_subscription(subscription, uidsetid, uid);
    if (!decoded)
    {
        send_bad_webpushapi_request(
            stream, "unsubscribe", "invalid subscription", decoded.error_reason);
        return;
    }

    find_hubrpc()->async_get(
        stream->ctx(),
        uidsetid,
        "/uidset/unsubscribe",
        { { "uidset", uidsetid },
          { "service", settings->webpushapi.service },
          { "uid", uid },
          { "subscription-id", settings->webpushapi.subscription_id } },
        [stream, &log_data](auto& ec, auto response) {
            if (ec || response.status != 200)
            {
                log_data["api_result"] = "unsubscribe failed";
                log_data["error"] = format_http_error(ec, response.status);
            }
            else
            {
                log_data["api_result"] = "unsubscribed";
            }
            handle_default_hub_codes(stream, ec, response);
        });
}

}}}
