#pragma once

#include "session.h"
#include <memory>
#include <unordered_map>

namespace yxiva { namespace web { namespace websocket_rpc {

struct session_registry : public std::enable_shared_from_this<session_registry>
{
    struct session_deleter
    {
        void operator()(session* session)
        {
            try
            {
                if (auto registry = weak_registry.lock())
                {
                    scoped_lock lock(registry->mutex);
                    registry->active.erase(session);
                }
            }
            catch (...)
            {
            }

            delete session;
        }
        std::weak_ptr<session_registry> weak_registry;
    };

    ~session_registry()
    {
        try
        {
            for (auto& pair : active)
            {
                if (auto s = pair.second.lock()) try
                    {
                        s->shutdown();
                    }
                    catch (...)
                    {
                    }
            }
        }
        catch (...)
        {
        }
    }

    template <typename... Args>
    std::shared_ptr<session> create(const websocket_stream_ptr& stream, Args&&... args)
    {
        std::shared_ptr<session> sess(
            new session(stream, std::forward<Args>(args)...),
            session_deleter{ shared_from_this() });
        scoped_lock lock(mutex);
        active.emplace(sess.get(), sess);
        return sess;
    }

    void clear()
    {
        decltype(active) tmp;
        {
            scoped_lock lock(mutex);
            std::swap(active, tmp);
        }
        for (auto& pair : tmp)
        {
            if (auto s = pair.second.lock()) s->shutdown();
        }
    }

    mutex mutex;
    std::unordered_map<session*, std::weak_ptr<session>> active;
};

}}}
