#pragma once

#include "types.h"
#include <yxiva/core/request_stats.h>

namespace yxiva { namespace web { namespace websocket_rpc {

struct stats
{
    stats(std::shared_ptr<request_stats> root_stats) : root_stats_(root_stats)
    {
    }

    request_stats::accumulator_t::value_type new_request()
    {
        return root_stats_->new_request();
    }

    void accept_request()
    {
        root_stats_->accept_request();
    }

    yplatform::ptree to_ptree() const
    {
        yplatform::ptree result = root_stats_->to_ptree();
        result.put("session", sessions.load());
        result.put("streams", streams.load());
        result.put("active_session", active_sessions.load());
        result.put("active_streams", active_streams.load());
        result.put("messages_received", messages_received.load());
        return result;
    }

    std::shared_ptr<request_stats> root_stats_;
    std::atomic<uint64_t> sessions = { 0 };
    std::atomic<uint64_t> streams = { 0 };
    std::atomic<uint64_t> active_sessions = { 0 };
    std::atomic<uint64_t> active_streams = { 0 };
    std::atomic<uint64_t> messages_received = { 0 };
};

}}}
