#pragma once

#include "web/future_close.h"

namespace yxiva::web::websocket_rpc {

using headers_pack = std::vector<std::pair<string, string>>;

inline void send_bad_request(
    const stream_ptr& stream,
    const string& info,
    const string& internal_info = string(),
    headers_pack&& = {})
{
    YLOG_CTX_GLOBAL(stream->ctx(), info)
        << "bad request: " << info << ", internal info: " << internal_info;
    stream->result(http_codes::bad_request, info);
}

inline void send_gone(const stream_ptr& stream, const string& info, headers_pack&& = {})
{
    YLOG_CTX_GLOBAL(stream->ctx(), info) << "gone: " << info;
    stream->result(http_codes::gone, info);
}

inline void send_unauthorized(const stream_ptr& stream, const string& info, headers_pack&& = {})
{
    YLOG_CTX_GLOBAL(stream->ctx(), info) << "unauthorized: " << info;
    stream->result(http_codes::unauthorized, info);
}

inline void send_internal_error(
    const stream_ptr& stream,
    const string& info,
    const string& internal_info = string(),
    headers_pack&& = {})
{
    YLOG_CTX_GLOBAL(stream->ctx(), info)
        << "internal error: " << info << ", internal_info: " << internal_info;
    stream->result(http_codes::internal_server_error, info);
}

inline void send_forbidden(const stream_ptr& stream, const string& info, headers_pack&& = {})
{
    YLOG_CTX_GLOBAL(stream->ctx(), info) << "forbidden: " << info;
    stream->result(http_codes::forbidden, info);
}

inline future_close make_future_close(std::shared_ptr<websocket_rpc::stream> stream)
{
    promise_close promise_session_closed;
    stream->set_close_hook(boost::bind(&promise_close::set, promise_session_closed));
    return promise_session_closed;
}

}