#pragma once

#include "types.h"
#include <memory>
#include <ymod_webserver/websocket.h>
#include "web/settings.h"
#include <processor/interface.h>
#include "base_web_subscriber.h"

namespace yxiva { namespace web {

typedef ymod_webserver::websocket::message ws_message_t;
typedef ymod_webserver::websocket::output_stream_ptr websocket_stream_ptr;

class websocket_subscriber : public base_web_subscriber
{
    typedef websocket_stream_ptr stream_ptr;
    typedef websocket_stream_weak_ptr stream_weak_ptr;

public:
    websocket_subscriber(
        task_context_ptr context,
        websocket_stream_ptr output_stream,
        formatters::formatter_ptr formatter,
        std::time_t sign_expiration,
        const time_duration& inactive_timeout,
        const string& client_id);

    void init();

    void notify_position(const position_message&) override;
    void notify_error(const error_message&) override;
    void ping(const ping_message&) override;

    void close() override;

    ~websocket_subscriber();

    boost::weak_ptr<websocket_subscriber> weak_from_this()
    {
        return boost::dynamic_pointer_cast<websocket_subscriber>(shared_from_this());
    }

protected:
    void impl_notify_text(const string& message) override;
    void impl_notify_binary(const string& header, const string& message) override;
    const string& name() const override;

private:
    void on_ws_message(ws_message_t const&);
    void perform_message(string const& text);
    stream_ptr stream();
    void reset_stream();

    mutex mux_;
    stream_ptr stream_;
    string input_buffer;
    time_duration inactive_timeout_;
};

}}
