#pragma once

#include "json_helpers.h"
#include "web/settings.h"
#include "web/stream_helpers.h"
#include "web/types.h"
#include <yxiva/core/platforms.h>

namespace yxiva { namespace web { namespace webui {

using namespace yxiva::apns;

inline void send_json_error(const http_stream_ptr& stream, http_codes::code cd, const string& error)
{
    json_value resp;
    resp["error"] = error;
    json_result(stream, cd, resp);
}

inline void send_bad_request(const http_stream_ptr& stream, const string& error)
{
    send_json_error(stream, http_codes::bad_request, error);
}

}}}
