#pragma once

#include "web/types.h"
#include <service_manager/service.h>
#include <yxiva/core/conf.h>

#include <stdexcept>
#include <string>
#include <utility>

namespace yxiva { namespace web { namespace webui {

using fields_type = std::vector<std::pair<const char*, json_type>>;

void check_optional_fields_throws(const json_value& data_json, const fields_type& fields);

void check_required_fields_throws(const json_value& data_json, const fields_type& fields);

operation::result parse_json_properties(const json_value& data_json, service_properties& data);

operation::result parse_json_properties(const json_value& data_json, send_token_properties& data);

operation::result parse_json_properties(const json_value& data_json, listen_token_properties& data);

void json_result(const http_stream_ptr& stream, http_codes::code cd, const json_value& resp);

void write_service(json_value_ref&& service_json, const service_data& service);
void write_app(json_value_ref&& app_json, const application_config& app);

template <typename DataType>
operation::result parse_request_properties(ymod_webserver::request_ptr req, DataType& data)
{
    json_value data_json;
    if (auto error = data_json.parse(std::string(req->raw_body.begin(), req->raw_body.end())))
    {
        return *error;
    }
    else
    {
        return parse_json_properties(data_json, data);
    }
}

}}}
