#pragma once

#include "common.h"

namespace yxiva { namespace web { namespace webui {

enum class owner_type
{
    user,
    abc,

    COUNT,
    unknown = -1
};

static const string OWNER_TYPE_ABC("abc");
static const string OWNER_PREFIX_ABC = OWNER_TYPE_ABC + ':';

inline owner_type owner_type_from_name(const string& name)
{
    if (name.empty()) return owner_type::user;
    if (name == OWNER_TYPE_ABC) return owner_type::abc;
    return owner_type::unknown;
}

inline const string& prefix_by_owner_type(const settings_ptr& settings, owner_type owner)
{
    if (owner == owner_type::abc) return OWNER_PREFIX_ABC;
    return settings->api.webui.auth_prefix;
}

}}}
