#pragma once

#include "auth.h"
#include "owner_type.h"
#include "common.h"
#include "web/auth/user.h"
#include "web/find_deps.h"

namespace yxiva { namespace web { namespace webui {

struct list
{
    void operator()(
        http_stream_ptr stream,
        settings_ptr settings,
        const auth_info& auth,
        const std::vector<string>& abc_services) const;
};

template <typename DataType>
class update_method
{
public:
    update_method(bool revoke = false, bool admin_only = false)
        : revoke(revoke), admin_only(admin_only)
    {
    }

    virtual ~update_method()
    {
    }

    virtual void operator()(
        const http_stream_ptr& stream,
        const settings_ptr& settings,
        bool admin,
        const string& owner_prefix,
        const string& owner_id,
        service_manager_ptr service_manager,
        const string& env = {}) const = 0;

protected:
    bool revoke;
    bool admin_only;
};

class service_create : public update_method<service_properties>
{
public:
    service_create() : update_method(false, true)
    {
    }

    virtual void operator()(
        const http_stream_ptr& stream,
        const settings_ptr& settings,
        bool admin,
        const string& owner_prefix,
        const string& owner_id,
        service_manager_ptr service_manager,
        const string& env = {}) const override;
};

class service_update : public update_method<service_properties>
{
public:
    service_update(bool revoke = false) : update_method(revoke)
    {
    }

    virtual void operator()(
        const http_stream_ptr& stream,
        const settings_ptr& settings,
        bool admin,
        const string& owner_prefix,
        const string& owner_id,
        service_manager_ptr service_manager,
        const string& env = {}) const override;
};

class send_token_update : public update_method<send_token_properties>
{
public:
    send_token_update(bool revoke = false) : update_method(revoke)
    {
    }

    virtual void operator()(
        const http_stream_ptr& stream,
        const settings_ptr& settings,
        bool admin,
        const string& owner_prefix,
        const string& owner_id,
        service_manager_ptr service_manager,
        const string& env = {}) const override;
};

class listen_token_update : public update_method<listen_token_properties>
{
public:
    listen_token_update(bool revoke = false) : update_method(revoke)
    {
    }

    virtual void operator()(
        const http_stream_ptr& stream,
        const settings_ptr& settings,
        bool admin,
        const string& owner_prefix,
        const string& owner_id,
        service_manager_ptr service_manager,
        const string& env = {}) const override;
};

class app_info
{
public:
    void operator()(
        const http_stream_ptr& stream,
        const settings_ptr& settings,
        bool admin,
        const string& owner_prefix,
        const string& owner_id,
        service_manager_ptr service_manager,
        const string& app,
        const string& platform) const;
};

class app_update : public update_method<application_config>
{
public:
    app_update(bool revoke = false) : update_method(revoke)
    {
    }

    virtual void operator()(
        const http_stream_ptr& stream,
        const settings_ptr& settings,
        bool admin,
        const string& owner_prefix,
        const string& owner_id,
        service_manager_ptr service_manager,
        const string& env = {}) const override;
};

class app_revert : public update_method<application_config>
{
public:
    app_revert() : update_method(false)
    {
    }

    virtual void operator()(
        const http_stream_ptr& stream,
        const settings_ptr& settings,
        bool admin,
        const string& owner_prefix,
        const string& owner_id,
        service_manager_ptr service_manager,
        const string& env = {}) const override;
};

struct unauthorized
{
    string unauthorized_message;

    unauthorized(const settings_ptr& settings);

    void operator()(http_stream_ptr stream);
};

}}}